import usb_cdc
usb_cdc.enable(console=True, data=True)

import board
import digitalio
import storage

# If the blue button is pressed when booting,
# then enable the USB drive and disable the logging to disk.
BTN_BLUE = board.D6
button = digitalio.DigitalInOut(BTN_BLUE)
button.pull = digitalio.Pull.UP

if button.value:
    # If button is not pressed, then the pull-up resistor
    # makes the voltage high and .value=True.
    # So this is the case when the button is NOT pressed!
    storage.disable_usb_drive()
