from core.utils.settings import get_string

# The following settings can be updated by setting them in settings.toml
DEVICE_NAME = get_string('DEVICE_NAME', "Catan")

import adafruit_logging as logging
import storage
log = logging.getLogger()
if not storage.getmount('/').readonly:
	fileHandler = logging.RotatingFileHandler('log.txt', maxBytes=50000, backupCount=3)
	fileHandler.setLevel(10)
	log.addHandler(fileHandler)
log.setLevel(10)
log.info(f"Logger Setup")

from core.buttons import Buttons
from microcontroller import Pin
from core.loop import main_loop, ErrorHandlerResumeOnButtonPress
from catan.player_mapper import Player_Mapper

player_mapper = Player_Mapper()

# ---------- VIEW AND CONNECTION SETUP -------------#
from core.connection.sgt_connection_serial import SgtConnectionSerial as SgtStreamConnection
FIELD_DIVIDER = ';'
FIELD_ORDER = ['sgtTimerMode','sgtState','sgtStateType','sgtColorHsv','sgtPlayerColorsHsv','sgtSeat','sgtTurnTime']

from catan.pwm_led_view import PWM_Leds_View
view = PWM_Leds_View(player_mapper)
view.set_state(None)
sgt_connection = SgtStreamConnection(view,
	device_name=DEVICE_NAME,
	field_order=FIELD_ORDER,
	field_divider=FIELD_DIVIDER,
)

# ---------- BUTTONS SETUP -------------#
buttons = Buttons({btn_pin: False for btn_pin in player_mapper.all_btn_pins})
def btn_callback(pin: Pin, presses: int, long_press: bool):
	log.info(f"Button pressed: {presses} times, long press: {long_press}")

	# Anyone can long press to toggle admin time.
	if long_press:
		sgt_connection.enqueue_send_toggle_admin()
		return

	# Only the active seat can do the short-press to send the end-turn command.
	active_pin = player_mapper.active_btn_pin

	if active_pin == None:
		log.info(f"Ignoring key press as there is no active pin associated with current seat.")
		return

	if active_pin != pin:
		log.info(f"Ignoring key press as pressed key is not active.")
		return

	sgt_connection.enqueue_send_primary()

# ---------- MAIN LOOP -------------#
error_handler = ErrorHandlerResumeOnButtonPress(view, buttons)
def on_connect():
	buttons.clear_callbacks()
	for btn_pin in player_mapper.all_btn_pins:
		buttons.set_callback(pin=btn_pin, presses=1, callback = btn_callback)
		buttons.set_callback(pin=btn_pin, presses=1, long_press=True, callback = btn_callback)

main_loop(sgt_connection, view, on_connect, error_handler.on_error, (buttons.loop,))