import board
from core.game_state import GameState, STATE_FINISHED, STATE_START
from core.color import PlayerColor
from microcontroller import Pin

LED_BLUE = board.D5
LED_RED = board.D0
LED_WHITE = board.D9
LED_ORANGE = board.D7

BTN_BLUE = board.D6
BTN_RED = board.D1
BTN_WHITE = board.D10
BTN_ORANGE = board.D8

ORANGE_HUE = 0.078125

class Player_Mapper():
	active_btn_pin: Pin | None = None
	active_led_pins: list[Pin] | None = None
	all_led_pins = [LED_BLUE, LED_ORANGE, LED_RED, LED_WHITE]
	all_btn_pins = [BTN_BLUE, BTN_ORANGE, BTN_RED, BTN_WHITE]

	def map_color_to_pins(self, color: PlayerColor):
		hue, saturation, value = color.base.fancy_color

		# These are the HSV of the Catan template
		# RED: 		(0.0, 1.0, 1.0)
		# BLUE: 	(0.6, 1.0, 1.0)
		# WHITE: 	(0.0, 0.0, 1.0)
		# ORANGE: 	(0.078125, 1.0, 1.0)

		if (saturation < 0.5):
			return (BTN_WHITE, LED_WHITE)
		elif (hue > 0.5 and hue < 0.7):
			return (BTN_BLUE, LED_BLUE)
		elif (hue > 0.9 or hue < ORANGE_HUE/2):
			return (BTN_RED, LED_RED)
		elif (hue >= ORANGE_HUE/2 and hue < 0.18):
			return (BTN_ORANGE, LED_ORANGE)
		else:
			return (None, None)

	def handle_new_state(self, state: GameState):
		if state == None:
			self.active_btn_pin = None
			self.active_led_pins = self.all_led_pins
		elif state.state in [STATE_FINISHED, STATE_START] or state.color_p == None or state.seat == None or len(state.seat) == 0 or len(state.seat) > 1 or state.seat[0] == 0:
			self.active_btn_pin = None
			self.active_led_pins = []
			for player in state.players:
				led_pin = self.map_color_to_pins(player.color)[1]
				if led_pin != None:
					self.active_led_pins.append(led_pin)
		else:
			btn, led = self.map_color_to_pins(state.color_p)
			self.active_btn_pin = btn
			self.active_led_pins = [led] if led != None else []