import adafruit_logging as logging
log = logging.getLogger()
import supervisor
import usb_cdc

from core.view.view import View
from core.connection.sgt_connection_stream import SgtConnectionStream

class SgtConnectionSerial(SgtConnectionStream):
	def __init__(self,
				view: View,
				device_name: str,
				field_order: list[str],
				field_divider: str,
				):
		super().__init__(view, field_order, field_divider)
		self.device_name = device_name
		if usb_cdc.data == None:
			raise RuntimeError("No CDC Data found")

	def is_connected(self) -> bool:
		return True

	def read_text_from_stream(self) -> str | None:
		if usb_cdc.data.in_waiting:
			usb_cdc.data.timeout = 0
			return usb_cdc.data.readline().decode()

	def pre_process_line(self, line):
		if line[1] == 'GET NAME':
			self.send(f"name={self.device_name}")
			return None
		elif line[1] == 'GET SCRIPT':
			self.send(f"script=%0A{self.field_divider.join(self.field_order)}%0A")
			return None
		elif line[1] == 'CLEAR':
			self.view.set_state(None)
			return None
		return line

	def send(self, value: str|None):
		if value != None:
			usb_cdc.data.write((value+"\n").encode("utf-8"))
			log.info(f"Send: {value}\n")